<?php

#============================================================
# URL SHRTN             | URL shortening/forwarding script
#------------------------------------------------------------
# Script provided by Glype Media, http://www.glype.com/
#============================================================

# Initialize app
require '../includes/init.php';

# Check authorisation
if ( empty($_SESSION['admin']) )
	localRedirect('admin/login.php');

# Find sort options
// Allowed options
$allowedSort = array('id','destination','hits','lastHit','createIP');
// Get from URL
$sort = empty($_GET['sort']) ? 'id' : (in_array($_GET['sort'],$allowedSort) ? $_GET['sort'] : 'id');
$dir = empty($_GET['dir']) || $_GET['dir'] != 'desc' ? '' : 'DESC';
// Build order by clause of query
$orderBy = ' ORDER BY ' . $sort . ' ' . $dir;

// Build where clause
$viewType = empty($_GET['type']) ? '' : $_GET['type'];
switch ( $viewType ) {
	case 'showip':
		// check inputted IP
		if ( empty($_GET['ip']) ) break;
		$ip = intval($_GET['ip']);
		$where = " WHERE createIP = '$ip' ";
		break;
	case 'search':
		if ( empty($_GET['terms'])) break;
		$terms = preg_replace('/[^A-Z0-9 .-]/i','',$_GET['terms']);
		$where = " WHERE destination LIKE '%$terms%' ";
		break;
	default:
		$where = '';
}

# Start position
$st = empty($_GET['st']) ? 0 : intval($_GET['st']);

# Work out base url for sorting options
$sortBase = preg_replace('/sort=([a-z]+)/i','',$_SERVER['PHP_SELF'].'?'.$_SERVER['QUERY_STRING']);
$sortBase = preg_replace('/dir=(asc|desc)/i','',$sortBase);
if ( substr($sortBase,-1) != '&' ) $sortBase .= '&';
$sortBase = preg_replace('/&+/','&',$sortBase);

# Top skin
require SKIN.'top.php';

# Print header
echo '
	<h1>Administrative Control Panel</h1>
	<form action="admin/index.php" method="get">
		<div style="float:right;padding:5px;">
		<input type="hidden" name="type" value="search">
		<input type="text" size="16" name="terms" value="Search destinations" onclick="if(this.value==\'Search destinations\') this.value=\'\';">
		<input type="submit" value="Go" class="button">
		</div>
	</form>
	<form action="admin/key2id.php" method="post">
		<div style="float:right;padding:5px;">
		<input type="text" size="10" name="key" value="Find key/id" onclick="if(this.value==\'Find key/id\') this.value=\'\';">
		<input type="submit" value="Go" class="button">
		</div>
	</form>
	<p>Showing ',$st,' to ',$st+$CONFIG['acpPage'],' ordered by ',$sort,($dir=='DESC'?' in descending order':''),'.</p>
	<form action="admin/delete.php" name="manage" method="post">
	<table cellspacing="1" cellpadding="2" width="100%">
		<tr>
			<th width="75"><a href="',$sortBase,'sort=id&dir=',($sort=='id'&&$dir==''?'desc':'asc'),'">ID</a></th>
			<th><a href="',$sortBase,'sort=destination&dir=',($sort=='destination'&&$dir==''?'desc':'asc'),'">Destination</a></th>
			<th width="20"><a href="',$sortBase,'sort=hits&dir=',($sort=='hits'&&$dir==''?'desc':'asc'),'">Hits</a></th>
			<th width="75"><a href="',$sortBase,'sort=lastHit&dir=',($sort=='lastHit'&&$dir==''?'desc':'asc'),'">Last</a></th>
			<th width="75"><a href="',$sortBase,'sort=createIP&dir=',($sort=='createIP'&&$dir==''?'desc':'asc'),'">Creator</a></th>
			<th width="10"> </th>
		</tr>
';

# Retrieve results
connect($CONFIG);
if ( mysql_num_rows($result=mysql_query("SELECT SQL_CALC_FOUND_ROWS * FROM shrt_urls $where $orderBy LIMIT $st,".$CONFIG['acpPage'])) ) {
	// Print rows
	while( $row = mysql_fetch_assoc($result) ) {
		echo '
		<tr>
			<td align="center"><a href="edit.php?id=',$row['id'],'" title="Edit">',id2key($row['id']),'</a></td>
			<td>',($row['cloak']?'<abbr style="float:right;" title="Cloaked"> C </abbr> ':''),($row['showTarget']?'<abbr style="float:right;" title="Show Target"> S </abbr>':''),'<a href="',$row['destination'],'">',str_replace('http://','',$row['destination']),'</a></td>
			<td align="center">',$row['hits'],'</td>
			<td align="center">',($row['lastHit']?date('j M Y',$row['lastHit']):'never'),'</td>
			<td align="center"><a href="admin/index.php?type=showip&ip=',$row['createIP'],'">',long2ip($row['createIP']),'</a></td>
			<td align="center"><input type="checkbox" name="url[',$row['id'],']" title="Delete"></td>
		</tr>
';
	}
} else
	echo '<tr><td colspan="6">No redirects found.</td></tr>';


echo '
		<tr>
			<th colspan="5" align="right"><input class="button" style="float:right;" type="submit" value="Delete Selected" onclick="if(!confirm(\'Are you sure you wish to delete all selected redirects?\')) return false;"></th>
			<th><input type="checkbox" name="checkall" onclick="checkUncheckAll(this);"></th>
		</tr>
	</table>
	</form>
	<script type="text/javascript">
		function checkUncheckAll(theElement) {
			var theForm = theElement.form, z = 0;
			for(z=0; z<theForm.length;z++){
				if(theForm[z].type == \'checkbox\' && theForm[z].name != \'checkall\'){
					theForm[z].checked = theElement.checked;
				}
			}
		}
		function pageJump(url,max,per) {
			var page = prompt(\'Jump to page number... (1 to \'+max+\')\',1);
			page = page > max ? max : page;
			page = page < 1 ? 1 : page;
			window.location=url+((parseInt(page)-1)*per);
		}
	</script>
';

# Sort page numbers
$total = mysql_result(mysql_query('SELECT FOUND_ROWS()'),0,0);
if ( $total > $CONFIG['acpPage'] ) {
	// We need pagination - determine number required
	$pagesNeeded = ceil($total/$CONFIG['acpPage']);

	// Determine current page
	$currentPage = $st ? ceil($st/$CONFIG['acpPage'])+1 : 1;

	// Change to page URL
	$URL = 'admin/index.php?'.preg_replace('/&?st=([0-9]+)/i','',$_SERVER['QUERY_STRING']);
	if ( substr($URL,-1) != '&' ) $URL .= '&';
	$URL .= 'st=';

	// Print page string
	echo '<p align="center">';
	if ( $currentPage > 2 )
		echo '<a href="',$URL,'0" title="First">&laquo;</a> ';
	if ( $currentPage > 1 )
		echo '<a href="',$URL,(($currentPage-2)*$CONFIG['acpPage']),'" title="Previous">&lt;</a> ';
	echo '[ <a onclick="pageJump(\'',$URL,'\',',$pagesNeeded,',',$CONFIG['acpPage'],');" title="Jump to page">Page</a> ',$currentPage,' of ',$pagesNeeded,'] ';
	if ( $currentPage < $pagesNeeded )
		echo '<a href="',$URL,(($currentPage)*$CONFIG['acpPage']),'" title="Next">&gt;</a> ';
	if ( $currentPage < $pagesNeeded-1 )
		echo '<a href="',$URL,(($pagesNeeded-1)*$CONFIG['acpPage']),'" title="Last">&raquo;</a> ';
	echo '</p>';
}

# Offer IP ban
if ( $viewType == 'showip' && !empty($_GET['ip']) )
	echo '<p>Troublesome user? <a href="admin/ban.php?ip=',$ip,'">Ban ',long2ip($ip),'</a>.</p>';

# Bottom skin
require SKIN.'bottom.php';

?>